/*
	File:		ProgressPane.cp

	Contains:	Demonstration of different progress indicators.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	 9/25/97	edv		Get rid of movie stuff for now.
		 <1>	 9/11/97	edv		First checked in.
*/

#include <Resources.h>
#include "ProgressPane.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"

enum
{
	kProgress1 = 1,
	kProgress2 = 2,
	kMovie		= 4
};

static OSErr		GetMyFileSpec( FSSpecPtr file );

ProgressPane::ProgressPane( DialogPtr dialog, SInt16 items ) : MegaPane( dialog, items )
{
	AppendDialogItemList( dialog, 6001, overlayDITL );
	
	fProgressValue = 0;
	fIsAscending = true;
	
	GetDialogItemAsControl( dialog, items + kProgress1, &fProgress1 );
	GetDialogItemAsControl( dialog, items + kProgress2, &fProgress2 );
	
	SetProgressIndicatorState( fProgress2, false );
}

ProgressPane::~ProgressPane()
{
	ShortenDITL( fDialog, CountDITL( fDialog ) - fOrigItems );
}

void
ProgressPane::Idle()
{
	IdleControls( fDialog );
	
	if ( fIsAscending )
	{
		fProgressValue += 2;
		if ( fProgressValue > 100 )
		{
			fProgressValue = 98;
			fIsAscending = false;
		}
	}
	else
	{
		fProgressValue -= 2;
		if ( fProgressValue < 0 )
		{
			fProgressValue = 2;
			fIsAscending = true;
		}
	}
	SetControlValue( fProgress1, fProgressValue );
}
